if (typeof MYAPP === 'undefined') {
    MYAPP = {};
}

MYAPP.loadScheme = function(o) {
    this.scheme = o;

    (function (scheme) {

        var preprocess = function (scheme) {

            var removeNullList = function (currentNode) {
                
                var prop, i;
                
                for (prop in currentNode) {
                    if (typeof currentNode[prop] === 'object') {
                        
                        removeNullList(currentNode[prop]);
                        
                        if (currentNode.list) {
                            for (i in currentNode.list) {
                                if ((currentNode.list[i].list && 
                                        currentNode.list[i].list.length == 0) ||
                                    (currentNode.list[i].step &&
                                        currentNode.list[i].step.list && 
                                        currentNode.list[i].step.list.length == 0) ||
                                    (currentNode.list[i].action &&
                                        currentNode.list[i].action.list && 
                                        currentNode.list[i].action.list.length == 0)) {
                                
                                    currentNode.list.splice(i, 1);
                                }
                            }
                        }
                    }
                }
            }
            
            var interPreProcess = function (scheme) {

                var prop,
                    currentNode,
                    arr,
                    i;

                currentNode = scheme.currentNode[scheme.currentNode.length - 1];

                for (prop in currentNode) {
                    if (!currentNode.hasOwnProperty(prop)) {
                        continue;
                    }

                    if (prop === 'pageId') {
                        continue;
                    }

                    if (typeof currentNode[prop] === 'object') {
                        scheme.currentNode.push(currentNode[prop]);

                        interPreProcess(scheme);

                        scheme.currentNode.pop();
                    }
                }

                if (currentNode.list) {
                    for (i = 0; i < currentNode.list.length; i += 1) {

                        if (currentNode.list[i].name) {
                            currentNode[currentNode.list[i].name] = currentNode.list[i];
                        }
                    }
                }

                if (currentNode.step) {

                    if (currentNode.step.defaultValue) {
                        if (currentNode.step[currentNode.step.defaultValue]) {
                            currentNode.defaultStep = currentNode.step[currentNode.step.defaultValue];
                        }
                    }

                    if (!currentNode.defaultStep) {
                        currentNode.defaultStep = currentNode.step.list[0];
                    }
                }

                if (currentNode.action) {

                    if (currentNode.action.defaultValue) {
                        if (currentNode.action[currentNode.action.defaultValue]) {
                            currentNode.defaultAction = currentNode.action[currentNode.action.defaultValue];
                        }
                        else {
                            assert(false);
                        }
                    }

                    if (!currentNode.defaultAction) {
                        currentNode.defaultAction = currentNode.action.list[0];
                    }

                }

                if (currentNode.pageUrl) {

                    scheme.root.pageId[currentNode.pageUrl] = {
                        arr: []
                    };

                    arr = scheme.root.pageId[currentNode.pageUrl].arr;

                    for (i = 0; i < scheme.currentNode.length - 2; i += 1) {
                        if (!scheme.currentNode[i].name) {
                            continue;
                        }

                        arr.push(scheme.currentNode[i].name);
                    }

                }

            };

            var _scheme = {
                    root: scheme,
                    currentNode: [
                        scheme
                    ]
                };

            if (!scheme.pageId) {
                scheme.pageId = {};
            }

            removeNullList(scheme);
            interPreProcess(_scheme);

        };

        if (typeof scheme.preprocess === 'undefined') {
            var start = new Date().getTime(),
                end;

            preprocess(scheme);

            end = new Date().getTime();

    //        console.log('Preprocess in ' + ((end - start)/1000).toString() + ' seconds');

    //        assert(scheme['Multicast']['MVR'].step['Configure Profile'].action.defaultValue === scheme['Multicast']['MVR'].step['Configure Profile'].defaultAction.name);

            scheme.preprocess = true;
        }

        if (typeof scheme.each === 'undefined') {
            scheme.each = function (node, cookie, fn) {

                var name;

                if (!cookie.parent) {
                    cookie.parent = [];
                }

                fn(node, cookie);

                if (cookie.found) {
                    return;
                }

                if (typeof node === 'object') {
                    for (name in node) {

                        if (!node.hasOwnProperty(name)) {
                            continue;
                        }

                        if (name === 'pageId') {
                            continue;
                        }

                        cookie.parent.push(node);

                        this.each(node[name], cookie, fn);

                        if (cookie.found) {
                            return;
                        }

                        cookie.parent.pop();

                    }
                }

            };
        }

    })(MYAPP.scheme);

};
